% drop degree variables

clear 
addpath('Routines')
addpath('Powell')

logfile_name=[mfilename '.log'];
result_name=[mfilename '_results'];
delete(logfile_name);
diary(logfile_name);


load('NLSY.mat')

diary on
summstats(dat,varnames)
diary off

% Sample selection: All
% female=getvariables(dat,varnames,{'female'});
% dat=dat(female==0,:);
n=size(dat,1);
% 

female=getvariables(dat,varnames,{'female'});
year=getvariables(dat,varnames,{'year'});
ID=getvariables(dat,varnames,{'ID'});


x1names={'children' 'married' 'sp_inc4'};
x1=getvariables(dat,varnames,x1names);

T1=min(year);
T2=max(year);
yr_names={};
tdummies=zeros(n,T2-T1);

for t=T1:T2-1
    tmp=['yr' num2str(t)];
    yr_names=cat(2,yr_names, {tmp});
    tdummies(:,t-T1+1)=(year==t);
end
summstats(tdummies,yr_names)
    
yname={'empl'};
y=getvariables(dat,varnames,yname);


% create nn 
% data for individual iobs is in rows nn(iobs,1) to nn(iobs,2)

IDs=unique(ID);
nobs=length(IDs);
nn=zeros(nobs,2);
nn(1,1)=1;
iobs=1;
for i=2:n
    if ID(i)~=ID(i-1)
        nn(iobs,2)=i-1;
        iobs=iobs+1;
        nn(iobs,1)=i;
    end
end
nn(iobs,2)=n;
if iobs~=nobs
    fprintf('something is wrong with panel structure')
end

y_lag=zeros(n,1)+NaN;
for i=2:n
    if (ID(i)==ID(i-1)) && (year(i)==(year(i-1)+1))
        y_lag(i)=y(i-1);
    end
end




% logit ignoring fixed effects
yy=y;
xx=[ones(n,1) y_lag x1 tdummies(:,2:size(tdummies,2))];
xxnames=cat(2,{'const.' 'lagged y'},cat(2,x1names,yr_names(2:length(yr_names))));

% get rid of ones without a lag
ii=find(~isnan(y_lag));
yy=yy(ii);
xx=xx(ii,:);
IIDD=ID(ii);

[blogit,slogit,f,H,V,scores]=estimate_logit(yy,xx);
cnames={'estimate' 'st.err.'};
Title='Logit';
diary on
write_res([blogit slogit],xxnames,cnames,Title,nobs)
diary off

IIDDs=unique(IIDD);
nobs1=length(IIDDs);
nn1=zeros(nobs1,2);
nn1(1,1)=1;
iobs=1;
for i=2:length(IIDD)
    if IIDD(i)~=IIDD(i-1)
        nn1(iobs,2)=i-1;
        iobs=iobs+1;
        nn1(iobs,1)=i;
    end
end
nn1(iobs,2)=length(IIDDs);
if iobs~=nobs1
    fprintf('\n something is wrong with panel structure\n')
end

xx1=xx(:,2:size(xx,2));
xx1names=cat(2,{'lagged y'},cat(2,x1names,yr_names(2:length(yr_names))));
print=true;
[blogit_FE0,slogit_FE0,fval,H,V,scores]=estimate_logit_FE(yy,xx1,nn1,blogit,1,print);

% Bootstrap
nboot=1000;
bbhat=zeros(nboot,length(blogit_FE0));
print=false;
rng(0,'twister');
for ib=1:nboot
    indx=randi([1 nobs1],nobs1,1);
    xxb=[];
    yyb=[];
    nnb=zeros(nobs1,2);
    nnb(1,1)=1;
    for i=1:nobs1
        iii=nn1(indx(i),1):nn1(indx(i),2);
        nnb(i,2)=nnb(i,1)+length(iii)-1;
        if i<nobs1
            nnb(i+1,1)=nnb(i,2)+1;
        end
        xxb=[xxb;xx1(iii,:)];
        yyb=[yyb;yy(iii,:)];
    end
    [bb,ss,fval,H,V,scores]=estimate_logit_FE(yyb,xxb,nnb,blogit,1,print);
    bbhat(ib,:)=bb';
end
slogit_FE0=iqr(bbhat)'/1.34;
        
    
    


cnames={'estimate' 'st.err. '};
Title='Logit Estimated FE 0';
diary on
write_res([blogit_FE0 slogit_FE0],xx1names,cnames,Title,nobs)
diary off

% SCALING
xx1(:,2)=xx1(:,2)/2;
xx1(:,4)=xx1(:,4)/10;
m=moments_nn(yy,xx1,nn1,blogit(2:length(blogit)));

a=(1./std(m));
a((a==Inf))=0;
W=diag(a.^2);


fun=@(b)GMM_fct1(yy,xx1,nn1,b,W);
opti=optimoptions(@fminunc,'MaxFunctionEvaluations',10000,'MaxIterations',10000,'Display','iter');
[bGMM,fval] = fminunc(fun, 1*blogit(2:length(blogit)),opti);
diary on
fprintf('\nFunction Value (fminunc)  %g\n\n',nobs*fval)
diary off

[bGMM,fval] = powell(fun,bGMM,100,1.0d-6);
diary on
fprintf('\nFunction Value (powell)   %g\n\n',nobs*fval)
diary off

opti=optimoptions(@fminunc,'MaxFunctionEvaluations',10000,'MaxIterations',10000,'Display','iter');
[bGMM,fval] = fminunc(fun, bGMM,opti);
sGMM=0*bGMM-99.999;


% Bootstrap
nboot=1000;
bbhat=zeros(nboot,length(blogit_FE0));
print=false;
rng(0,'twister');
for ib=1:nboot
    pri(ib)
    tic
    indx=randi([1 nobs1],nobs1,1);
    xxb=[];
    yyb=[];
    nnb=zeros(nobs1,2);
    nnb(1,1)=1;
    for i=1:nobs1
        iii=nn1(indx(i),1):nn1(indx(i),2);
        nnb(i,2)=nnb(i,1)+length(iii)-1;
        if i<nobs1
            nnb(i+1,1)=nnb(i,2)+1;
        end
        xxb=[xxb;xx1(iii,:)];
        yyb=[yyb;yy(iii,:)];
    end
    fun=@(b)GMM_fct1(yyb,xxb,nnb,b,W);
    opti=optimoptions(@fminunc,'MaxFunctionEvaluations',10000,'MaxIterations',10000,'Display','off');
    [bb,fval] = fminunc(fun, bGMM,opti);
    bbhat(ib,:)=bb';
    toc
end
sGMM=iqr(bbhat)'/1.3490;

% SCALING
bGMM(2)=bGMM(2)/2;
bGMM(4)=bGMM(4)/10;
sGMM(2)=sGMM(2)/2;
sGMM(4)=sGMM(4)/10;
cnames={'estimate' 'st.err.'};
Title='GMM Estimation (b_start=Logit MLE)';
diary on
write_res([bGMM sGMM],xx1names,cnames,Title,nobs)
fprintf('\nFunction Value (fminunc)  %g\n\n',nobs*fval)
diary off
save(result_name);

